Attribute VB_Name = "basListView"
'******************************************************************************
' Implements ListView declarations and functions
'******************************************************************************
' FileName:  basListView.bas
' Creator:   Christian Forsberg
' Created:   2001-02-05
'******************************************************************************
' Version   Date   Who Comment
' 00.00.000 010205 CFO Created
'******************************************************************************
Option Explicit

' API declarations
Public Declare Function GetFocus Lib "Coredll" () As Long
Public Declare Function SendMessage Lib "Coredll" Alias "SendMessageW" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Public Declare Function SendMessageString Lib "Coredll" Alias "SendMessageW" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String) As Long

' ListView constants
Public Const LVM_GETEXTENDEDLISTVIEWSTYLE = &H1037
Public Const LVM_SETEXTENDEDLISTVIEWSTYLE = &H1036
Public Const LVM_GETITEMSTATE = &H102C
Public Const LVM_SETITEMSTATE = &H102B
Public Const LVM_SETCOLUMNWIDTH = &H101E
Public Const LVSCW_AUTOSIZE = -1
Public Const LVSCW_AUTOSIZE_USEHEADER = -2
Public Const LVS_EX_GRIDLINES = &H1
Public Const LVS_EX_SUBITEMIMAGES = &H2
Public Const LVS_EX_CHECKBOXES = &H4
Public Const LVS_EX_TRACKSELECT = &H8
Public Const LVS_EX_HEADERDRAGDROP = &H10
Public Const LVS_EX_FULLROWSELECT = &H20   ' applies to report mode only
Public Const LVS_EX_ONECLICKACTIVATE = &H40
Public Const LVIS_STATEIMAGEMASK = &HF000
Public Sub SetFullRowSelect(hWnd As Long)
  
' Set a ListView to full row select and enable headers to be moved.
' IN:  hWnd, hWnd to ListView control (retrieved with GetFocus function)
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010205 CFO Created
'******************************************************************************
  Dim lStyle As Long

  lStyle = SendMessage(hWnd, LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0)
  lStyle = lStyle Or LVS_EX_FULLROWSELECT Or LVS_EX_HEADERDRAGDROP
  Call SendMessage(hWnd, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, lStyle)

End Sub
Public Sub AutoSizeColumns(lvw As ListViewCtrl)

' Autosize all columns in ListView.
' IN:  lvw, ListView control
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010205 CFO Created
'******************************************************************************
  Dim l As Long
  Dim hWnd As Long

  ' Get ListView control windows handle
  lvw.SetFocus
  hWnd = GetFocus()

  ' Autosize columns
  For l = 0 To lvw.ColumnHeaders.Count - 1
    Call SendMessage(hWnd, LVM_SETCOLUMNWIDTH, l, LVSCW_AUTOSIZE)
  Next

End Sub
Public Sub SetCheckBoxes(hWnd As Long)
  
' Set a ListView to have CheckBoxes.
' IN:  hWnd, hWnd to ListView control (retrieved with GetFocus function)
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010301 CFO Created
'******************************************************************************
  Dim lStyle As Long

  lStyle = SendMessage(hWnd, LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0)
  lStyle = lStyle Or LVS_EX_CHECKBOXES
  Call SendMessage(hWnd, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, lStyle)

End Sub
Public Function GetCheckState(hWnd As Long, Index As Long) As Boolean

' Get the state of a CheckBox in a ListView.
' IN:  hWnd, hWnd to ListView control (retrieved with GetFocus function)
'      Index, ListIndex in ListView
' OUT: GetCheckState, checkbox state (True/False)
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010301 CFO Created
'******************************************************************************

  GetCheckState = CInt((SendMessage(hWnd, LVM_GETITEMSTATE, Index - 1, LVIS_STATEIMAGEMASK) / 2 ^ 12) - 1) > 0

End Function
Public Sub SetCheckState(hWnd As Long, Index As Long, State As Boolean)

' Set a ListView to have CheckBoxes.
' IN:  hWnd, hWnd to ListView control (retrieved with GetFocus function)
'      Index, ListIndex in ListView
'      State, set or clear checkbox (True/False)
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010301 CFO Created
'******************************************************************************
  Dim lsLVITEM As String
  Dim llResult As Long
  Dim liStateValue As Integer

  ' Set state value
  If State Then
    liStateValue = &H2000
  Else
    liStateValue = &H1000
  End If
  
  ' Set members "state" and "stateMask"
  '.state = liStateValue
  '.stateMask = LVIS_STATEIMAGEMASK
  lsLVITEM = LongToBytes(0) & LongToBytes(0) & LongToBytes(0) & _
             LongToBytes(liStateValue) & LongToBytes(LVIS_STATEIMAGEMASK) & _
             LongToBytes(0) & LongToBytes(0) & _
             LongToBytes(0) & LongToBytes(0) & LongToBytes(0)

  llResult = SendMessageString(hWnd, LVM_SETITEMSTATE, i - 1, lsLVITEM)

End Sub
Public Sub ClearAllCheckState(hWnd As Long)

' Clear all CheckBoxes in ListView (with CheckBoxes enabled).
' IN:  hWnd, hWnd to ListView control (retrieved with GetFocus function)
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010301 CFO Created
'******************************************************************************
  Dim lsLVITEM As String
  Dim llResult As Long

  lsLVITEM = LongToBytes(0) & LongToBytes(0) & LongToBytes(0) & _
             LongToBytes(&H1000) & LongToBytes(LVIS_STATEIMAGEMASK) & _
             LongToBytes(0) & LongToBytes(0) & _
             LongToBytes(0) & LongToBytes(0) & LongToBytes(0)

  llResult = SendMessageString(hWnd, LVM_SETITEMSTATE, -1, lsLVITEM)

End Sub
