Attribute VB_Name = "basProgressBar"
Option Explicit

' Variable to pass the Window Handler
Private ProgressBarCtl_hWnd As Long

' Constants
Private Const PROGRESS_CLASS = "msctls_progress32"
Private Const ICC_PROGRESS_CLASS = &H20

Private Const WS_BORDER = &H800000
Private Const WS_CHILD = &H40000000
Private Const WS_VISIBLE = &H10000000

Private Const SWP_NOSIZE = &H1
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOZORDER = &H4
Private Const SWP_FRAMECHANGED = &H20  ' The frame changed: send WM_NCCALCSIZE

Private Const GWL_STYLE = (-16)
Private Const GWL_EXSTYLE = (-20)

' ProgressBar Messages
Private Const PBS_SMOOTH = &H1
Private Const PBS_VERTICAL = &H4
Private Const PBM_SETRANGE = &H401
Private Const PBM_SETPOS = &H402
Private Const PBM_DELTAPOS = &H403
Private Const PBM_SETSTEP = &H404
Private Const PBM_STEPIT = &H405
Private Const PBM_SETRANGE32 = &H406 ' lParam = high, wParam = low
Private Const PBM_GETRANGE = &H407 ' wParam = return (TRUE ? low : high). lParam = PPBRANGE or NULL
Private Const PBM_GETPOS = &H408
'typedef struct
'{
'   int iLow;
'   int iHigh;
'} PBRANGE, *PPBRANGE;

' API Declares
Declare Function SetWindowPos Lib "Coredll" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Declare Function SendMessageString Lib "Coredll" Alias "SendMessageW" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String) As Long
Declare Function SendMessage Lib "Coredll" Alias "SendMessageW" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Declare Function CreateWindowEx Lib "Coredll" Alias "CreateWindowExW" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, ByVal lpParam As String) As Long
Declare Function InitCommonControlsEx Lib "Commctrl" (ByVal LPINITCOMMONCONTROLSEX As String) As Boolean
Declare Function SetWindowLong Lib "Coredll" Alias "SetWindowLongW" (ByVal hWnd As Long, ByVal nIndex As Long, ByVal NewLong As Long) As Long
Declare Function GetWindowLong Lib "Coredll" Alias "GetWindowLongW" (ByVal hWnd As Long, ByVal nIndex As Long) As Long
Public Sub ProgressBarCtl_Load(hwndOwner As Long, g_hinst As Long, ByVal cLeft As Long, ByVal cTop As Long, ByVal cWidth As Long, ByVal cHeight As Long, ByVal Smooth As Boolean)

  Dim lStyle As Long
  Dim udtINITCCEX As String ' To hold INITCOMMONCONTROLSEX udt
  Dim udtRECT As String: udtRECT = Space(8) ' Reserve 16 bytes for RECT udt
    
  ' Create INITCOMMONCONTROLSEX udt...
  udtINITCCEX = setINITCOMMONCONTROLSEX(8, ICC_PROGRESS_CLASS)
  ' ...and initialize Common Controls
  Call InitCommonControlsEx(udtINITCCEX)
    
  ' Set Style
  If Smooth Then lStyle = PBS_SMOOTH
  
  ' Create the month calendar (resize it later)
  ProgressBarCtl_hWnd = CreateWindowEx(0, PROGRESS_CLASS, "", WS_BORDER + WS_CHILD + WS_VISIBLE + lStyle, 0, 0, 0, 0, hwndOwner, vbNull, g_hinst, vbNull)

  ' Resize the control
  Call SetWindowPos(ProgressBarCtl_hWnd, vbNull, cLeft, cTop, cWidth, cHeight, SWP_NOZORDER)

End Sub
Private Function ProgressBarCtl_SetRange(ByVal MinValue As Integer, ByVal MaxValue As Long) As Long
    
  ' Set range
  ProgressBarCtl_SetRange = SendMessage(ProgressBarCtl_hWnd, PBM_SETRANGE32, MinValue, MaxValue)

End Function
Private Function ProgressBarCtl_SetPos(ByVal PosValue As Integer) As Long
    
  ' Set pos
  ProgressBarCtl_SetPos = SendMessage(ProgressBarCtl_hWnd, PBM_SETPOS, PosValue, 0)

End Function
'Public Function ProgressBarCtl_Smooth(ByVal Value As Boolean) As Long
'  Dim lStyle As Long
'
'  ' Set smooth
'  lStyle = GetWindowLong(ProgressBarCtl_hWnd, GWL_STYLE)
'  If Value Then
'    lStyle = lStyle Or PBS_SMOOTH
'  Else
'    lStyle = lStyle And (Not PBS_SMOOTH)
'  End If
'  ProgressBarCtl_Smooth = SetWindowLong(ProgressBarCtl_hWnd, GWL_STYLE, lStyle)
'  Call SetWindowPos(ProgressBarCtl_hWnd, vbNull, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE Or SWP_NOZORDER Or SWP_FRAMECHANGED)
'
'End Function
Public Function ProgressBarCtl_Border(ByVal Value As Boolean) As Long
  Dim lStyle As Long
  
  ' Set smooth
  lStyle = GetWindowLong(ProgressBarCtl_hWnd, GWL_STYLE)
  If Value Then
    lStyle = lStyle Or WS_BORDER
  Else
    lStyle = lStyle And (Not WS_BORDER)
  End If
  ProgressBarCtl_Border = SetWindowLong(ProgressBarCtl_hWnd, GWL_STYLE, lStyle)

End Function
Private Function setINITCOMMONCONTROLSEX(ByVal dwSize As Long, ByVal dwICC As Long) As String
    
  ' Build INITCOMMONCONTROLSEX UDT:
  'Type LPINITCOMMONCONTROLSEX
  '  dwSize As Long
  '  dwICC As Long
  'End Type
  
  setINITCOMMONCONTROLSEX = LongToBytes(dwSize) & LongToBytes(dwICC)

End Function
Private Function LongToBytes(ByVal Value As Long) As String
  
  Dim lsHex As String, i As Integer
  
  lsHex = Right("00000000" & Hex(Value), 8)
  For i = 1 To 7 Step 2
    LongToBytes = ChrB(CInt("&H" & Mid(lsHex, i, 2))) & LongToBytes
  Next

End Function

