Attribute VB_Name = "basDatePicker"
Option Explicit

' Variable to pass the Window Handler
Private DateTimePickCtl_hWnd As Long

' Constants
Private Const DATETIMEPICK_CLASS = "SysDateTimePick32"
Private Const ICC_DATE_CLASSES = &H100&

Private Const WS_BORDER = &H800000
Private Const WS_CHILD = &H40000000
Private Const WS_VISIBLE = &H10000000

Private Const SWP_NOZORDER = 4

' DateTimePicker Messages
Private Const DTM_GETSYSTEMTIME = &H1001
Private Const DTM_SETSYSTEMTIME = &H1002
Private Const DTM_GETRANGE = &H1003
Private Const DTM_SETRANGE = &H1004
Private Const DTM_SETFORMAT = &H1032
Private Const DTM_SETMCCOLOR = &H1006
Private Const DTM_GETMCCOLOR = &H1007
Private Const DTM_GETMONTHCAL = &H1008
Private Const DTM_SETMCFONT = &H1009
Private Const DTM_GETMCFONT = &H1010

' DateTimePicker styles
Private Const DTS_UPDOWN = &H1             ' use UPDOWN instead of MONTHCAL
Private Const DTS_SHOWNONE = &H2           ' allow a NONE or checkbox selection
Private Const DTS_SHORTDATEFORMAT = &H0    ' use the short date format (app must forward WM_WININICHANGE messages)
Private Const DTS_LONGDATEFORMAT = &H4     ' use the long date format (app must forward WM_WININICHANGE messages)
Private Const DTS_TIMEFORMAT = &H9         ' use the time format (app must forward WM_WININICHANGE messages)
Private Const DTS_APPCANPARSE = &H10       ' allow user entered strings (app MUST respond to DTN_USERSTRING)
Private Const DTS_RIGHTALIGN = &H20        ' right-align popup instead of left-align it
Private Const DTS_NONEBUTTON = &H80        ' use NONE button instead of checkbox

' Month Calendar color atributes
Private Const MCSC_BACKGROUND = 0   ' Background color (between months)
Private Const MCSC_TEXT = 1         ' Dates within a month
Private Const MCSC_TITLEBK = 2      ' Background of the title
Private Const MCSC_TITLETEXT = 3    ' Text within the calendar's title
Private Const MCSC_MONTHBK = 4      ' Background of a month
Private Const MCSC_TRAILINGTEXT = 5 ' The text color of header & trailing days

' API Declares
Declare Function SetWindowPos Lib "Coredll" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Declare Function SendMessageString Lib "Coredll" Alias "SendMessageW" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String) As Long
Declare Function SendMessage Lib "Coredll" Alias "SendMessageW" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Declare Function CreateWindowEx Lib "Coredll" Alias "CreateWindowExW" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, ByVal lpParam As String) As Long
Declare Function InitCommonControlsEx Lib "Commctrl" (ByVal LPINITCOMMONCONTROLSEX As String) As Boolean
Public Sub DateTimePickCtl_Load(hwndOwner As Long, g_hinst As Long, cLeft As Long, cTop As Long, ByVal cWidth As Long, ByVal cHeight As Long, ByVal Style As Long)

  Dim udtINITCCEX As String 'To hold INITCOMMONCONTROLSEX udt
  Dim udtRECT As String: udtRECT = Space(8) 'Reserve 16 bytes for RECT udt
    
  ' Create INITCOMMONCONTROLSEX udt...
  udtINITCCEX = setINITCOMMONCONTROLSEX(8, ICC_DATE_CLASSES)
  ' ...and initialize Common Controls
  Call InitCommonControlsEx(udtINITCCEX)
  
  ' Create the month calendar (resize it later)
  DateTimePickCtl_hWnd = CreateWindowEx(0, DATETIMEPICK_CLASS, "", WS_BORDER + WS_CHILD + WS_VISIBLE + Style, 0, 0, 0, 0, hwndOwner, vbNull, g_hinst, vbNull)

  ' Resize the control
  Call SetWindowPos(DateTimePickCtl_hWnd, vbNull, cLeft, cTop, cWidth, cHeight, SWP_NOZORDER)
  
End Sub
Public Function DateTimePickCtl_SetColor(iColor As Long, clr As Long) As Long
    
  ' Set colors to draw control
  DateTimePickCtl_SetColor = SendMessage(DateTimePickCtl_hWnd, DTM_SETMCCOLOR, iColor, clr)

End Function
Public Function DateTimePickCtl_SetFormat(ByVal FormatString As String) As Long
    
  ' Set colors to draw control
  DateTimePickCtl_SetFormat = SendMessageString(DateTimePickCtl_hWnd, DTM_SETFORMAT, 0, FormatString)

End Function
Public Function DateTimePickCtl_GetDateTime() As Date
  
  Dim wYear As Integer, wMonth As Integer, wDayOfWeek As Integer, wDay As Integer
  Dim wHour As Integer, wMinute As Integer, wSecond As Integer, wMSecond As Integer
  Dim udtSYSTEMTIME As String
  
  udtSYSTEMTIME = Space(8) ' Reserve 16 bytes for SYSTEMTIME udt
    
  ' Get the date currently selected
  Call SendMessageString(DateTimePickCtl_hWnd, DTM_GETSYSTEMTIME, 0, udtSYSTEMTIME)
  
  ' Read SYSTEMTIME udt items...
  Call getSYSTEMTIME(udtSYSTEMTIME, wYear, wMonth, wDayOfWeek, wDay, wHour, wMinute, wSecond, wMSecond)
  ' ...and convert them to a Date value
  DateTimePickCtl_GetDateTime = DateSerial(wYear, wMonth, wDay) + TimeSerial(wHour, wMinute, wSecond + wMSecond / 1000)
    
End Function
Public Sub DateTimePickCtl_SetDateTime(ByVal Value As Date)
  
  Dim wYear As Integer, wMonth As Integer, wDayOfWeek As Integer, wDay As Integer
  Dim wHour As Integer, wMinute As Integer, wSecond As Integer, wMSecond As Integer
  Dim udtSYSTEMTIME As String
  
  udtSYSTEMTIME = Space(8) ' Reserve 16 bytes for SYSTEMTIME UDT
    
  wYear = Year(Value)
  wMonth = Month(Value)
  wDayOfWeek = Weekday(Value)
  wDay = Day(Value)
  wHour = Hour(Value)
  wMinute = Minute(Value)
  wSecond = Second(Value)
  wMSecond = 0
  
  ' Read SYSTEMTIME udt items...
  Call setSYSTEMTIME(udtSYSTEMTIME, wYear, wMonth, wDayOfWeek, wDay, wHour, wMinute, wSecond, wMSecond)
    
  ' Set the current date to be selected
  Call SendMessageString(DateTimePickCtl_hWnd, DTM_SETSYSTEMTIME, 0, udtSYSTEMTIME)
  
End Sub
Private Function DateTimePickCtl_GetMinReqRect(prc As String) As Long
    
  ' Get minimum size required to display a full month
  DateTimePickCtl_GetMinReqRect = SendMessageString(DateTimePickCtl_hWnd, MCM_GETMINREQRECT, 0, prc)

End Function
Public Sub getSYSTEMTIME(ByVal str As String, ByRef wYear As Integer, ByRef wMonth As Integer, ByRef wDayOfWeek As Integer, ByRef wDay As Integer, ByRef wHour As Integer, ByRef wMinute As Integer, ByRef wSecond As Integer, ByRef wMSecond As Integer)
    
  ' Read SYSTEMTIME UDT components
  wYear = BytesToInteger(MidB(str, 1, 2))
  wMonth = BytesToInteger(MidB(str, 3, 2))
  wDayOfWeek = BytesToInteger(MidB(str, 5, 2))
  wDay = BytesToInteger(MidB(str, 7, 2))
  wHour = BytesToInteger(MidB(str, 9, 2))
  wMinute = BytesToInteger(MidB(str, 11, 2))
  wSecond = BytesToInteger(MidB(str, 13, 2))
  wMSecond = BytesToInteger(MidB(str, 15, 2))

End Sub
Public Sub setSYSTEMTIME(ByRef str As String, ByVal wYear As Integer, ByVal wMonth As Integer, ByVal wDayOfWeek As Integer, ByVal wDay As Integer, ByVal wHour As Integer, ByVal wMinute As Integer, ByVal wSecond As Integer, ByVal wMSecond As Integer)
    
  ' Set SYSTEMTIME UDT components
  str = IntegerToBytes(wYear) & _
        IntegerToBytes(wMonth) & _
        IntegerToBytes(wDayOfWeek) & _
        IntegerToBytes(wDay) & _
        IntegerToBytes(wHour) & _
        IntegerToBytes(wMinute) & _
        IntegerToBytes(wSecond) & _
        IntegerToBytes(wMSecond)
        
End Sub
Private Function getRECT(ByVal RECT As String, ByRef RECTleft As Long, ByRef RECTtop As Long, ByRef RECTright As Long, ByRef RECTbottom As Long) As Long
    
  ' Read RECT UDT components:
  'Type RECT
  '  Left As Long
  '  Top As Long
  '  Right As Long
  '  Bottom As Long
  'End Type
  
  RECTleft = BytesToLong(MidB(RECT, 1, 4))
  RECTtop = BytesToLong(MidB(RECT, 5, 4))
  RECTright = BytesToLong(MidB(RECT, 9, 4))
  RECTbottom = BytesToLong(MidB(RECT, 13, 4))

End Function
Private Function setINITCOMMONCONTROLSEX(ByVal dwSize As Long, ByVal dwICC As Long) As String
    
  ' Build INITCOMMONCONTROLSEX UDT:
  'Type LPINITCOMMONCONTROLSEX
  '  dwSize As Long
  '  dwICC As Long
  'End Type
  
  setINITCOMMONCONTROLSEX = LongToBytes(dwSize) & LongToBytes(dwICC)

End Function
Function LongToBytes(ByVal Value As Long) As String
  
  Dim lsHex As String, i As Integer
  
  lsHex = Right("00000000" & Hex(Value), 8)
  For i = 1 To 7 Step 2
    LongToBytes = ChrB(CInt("&H" & Mid(lsHex, i, 2))) & LongToBytes
  Next

End Function
Function BytesToLong(ByVal Value As String) As Long
  
  Dim lsHex As String, i As Integer
  
  For i = 1 To 4
    lsHex = Hex(AscB(MidB(Value, i, 1))) & lsHex
  Next
  BytesToLong = CLng("&H" & lsHex)

End Function
Function IntegerToBytes(ByVal Value As Integer) As String
  
  Dim lsHex As String, i As Integer
  
  lsHex = Right("0000" & Hex(Value), 4)
  For i = 1 To 3 Step 2
    IntegerToBytes = ChrB(CInt("&H" & Mid(lsHex, i, 2))) & IntegerToBytes
  Next

End Function
Function BytesToInteger(ByVal Value As String) As Integer
  
  BytesToInteger = CLng("&H" & Hex(AscB(MidB(Value, 2, 1))) & Hex(AscB(MidB(Value, 1, 1))))

End Function
