Attribute VB_Name = "basGlobal"
'*****************************
' General declarations and functions
'*****************************
' FileName:  basGlobal.bas
' Creator:        Andreas Sjostrom
' Created:        2001-03-14
'*****************************
' Version   Date   Who Comment
' 00.00.000 010313 ASJ Created
'*****************************
Option Explicit

' Private variables
Private pfrmCurrentForm As Form

' Misc constants
Public Const vbHourGlass = 11
Public Const vbArrow = 1

' Pocket Outlook constants
' Tasks
Const olImportanceLow = 0
Const olImportanceNormal = 1
Const olImportanceHigh = 2

' Folder types
Const olFolderCalendar = 9
Const olFolderContacts = 10
Const olFolderTasks = 13
Const olFolderCities = 101
Const olFolderInfrared = 102

' Item types
Const olAppointmentItem = 1
Const olContactItem = 2
Const olTaskItem = 3
Const olCityItem = 101

' Recurrence types
Const olRecursDaily = 0
Const olRecursWeekly = 1
Const olRecursMonthly = 2
Const olRecursMonthNth = 3
Const olRecursYearly = 5
Const olRecursYearNth = 6

' Days of Week
Const olSunday = 1
Const olMonday = 2
Const olTuesday = 4
Const olWednesday = 8
Const olThursday = 16
Const olFriday = 32
Const olSaturday = 64

' Reminder Options
Const olLED = 1
Const olVibrate = 2
Const olDialog = 4
Const olSound = 8
Const olRepeat = 16

' Current City
Const olHomeCity = 0
Const olVisitingCity = 1

' Busy Status
Const olFree = 0
Const olTentative = 1
Const olBusy = 2
Const olOutOfOffice = 3
 
' Sensitivity
Const olNormal = 0
Const olPrivate = 2
    
' MeetingStatus
Const olNonMeeting = 0
Const olMeeting = 1

' Declarations for ListView Extended Properties (like FullRowSelect)
Public Declare Function GetFocus Lib "coredll" () As Long
Public Declare Function SendMessage Lib "coredll" Alias "SendMessageW" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Public Const LVM_FIRST = &H1000
Public Const LVM_GETEXTENDEDLISTVIEWSTYLE = &H1037
Public Const LVM_SETEXTENDEDLISTVIEWSTYLE = &H1036
Public Const LVS_EX_GRIDLINES = &H1
Public Const LVS_EX_SUBITEMIMAGES = &H2
Public Const LVS_EX_CHECKBOXES = &H4
Public Const LVS_EX_TRACKSELECT = &H8
Public Const LVS_EX_HEADERDRAGDROP = &H10
Public Const LVS_EX_FULLROWSELECT = &H20   ' applies to report mode only
Public Const LVS_EX_ONECLICKACTIVATE = &H40
Public Const LVS_EX_TWOCLICKACTIVATE = &H80
Public Const LVS_EX_FLATSB = &H100          ' This and rest for IE4 or later
Public Const LVS_EX_REGIONAL = &H200        ' ...
Public Const LVS_EX_INFOTIP = &H400         ' listview does InfoTips for you
Public Const LVS_EX_UNDERLINEHOT = &H800
Public Const LVS_EX_UNDERLINECOLD = &H1000
Public Const LVS_EX_MULTIWORKAREAS = &H2000

Public Sub MakeInvisible(ByVal CurrentForm As Form)
'*****************************
'Makes the form invisible and turns on hourglass
'
'Parameters:
'N/A
'
'Return:
'N/A
'
'History:
' Version   Date    Who     Comment
' 00.00.000 010124  AS      Created
'*****************************

    Set pfrmCurrentForm = CurrentForm

    ' Show hourglass
    Screen.MousePointer = vbHourGlass

    ' Make invisible
    pfrmCurrentForm.Visible = False
    
End Sub

Public Sub MakeVisible(ByVal CurrentForm As Form)
'*****************************
'LoadMenu
'Makes the form visible and restore mousepointer
'
'Parameters:
'N/A
'
'Return:
'N/A
'
'History:
' Version   Date    Who     Comment
' 00.00.000 010124  AS      Created
'*****************************

    Set pfrmCurrentForm = CurrentForm

    ' Make visible
    pfrmCurrentForm.Visible = True
    
    ' Show form
    pfrmCurrentForm.Show
    
    ' Restore mousepointer
    Screen.MousePointer = vbArrow

End Sub

Public Sub SetFullRowSelect(hWnd As Long)
  
' Set a ListView to full row select.
' IN:  hWnd, hWnd to ListView control (retrieved with GetFocus function)
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010205 CFO Created
'******************************************************************************
  Dim lStyle As Long

  lStyle = SendMessage(GetFocus(), LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0)
  lStyle = lStyle Or LVS_EX_FULLROWSELECT
  Call SendMessage(hWnd, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, lStyle)

End Sub
