Attribute VB_Name = "basSOAPClient"
'******************************************************************************
' Module for SOAP Client functions
'******************************************************************************
' FileName:  SOAPClient.bas
' Creator:   Christian Forsberg
' Created:   2001-03-16
'******************************************************************************
' Version   Date   Who Comment
' 00.00.000 010316 CFO Created
'******************************************************************************
Option Explicit
Public Function SOAPCall(ByVal Namespace As String, ByVal Listener As String, ByVal Method As String, ByVal Arguments As Variant, SOAPAction As String, ShowPackets As Boolean) As String

' Call a SOAP service/method and return response.
' IN:  Namespace, namespace
'      Listener, listener URL
'      Method, method to call
'      Arguments, method parameters as Variant array
'      SOAPAction, soap action (if "" defaults to "Namespace#Method")
'      ShowPackets, indicates if XML packages (payload) should be shown
' OUT: SOAPCall, return value (from SOAP response)
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010316 CFO Created
'******************************************************************************
  Dim loXMLHTTP As XMLHTTPRequest
  Dim lsRequest As String
  Dim lsResponse As String
  Dim i As Integer

  ' Set Payload
  lsRequest = lsRequest & "<S:Envelope xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'" & vbCrLf
  lsRequest = lsRequest & " xmlns:SOAP-ENC='http://schemas.xmlsoap.org/soap/encoding/'" & vbCrLf
  lsRequest = lsRequest & " S:encodingStyle='http://schemas.xmlsoap.org/soap/encoding/'" & vbCrLf
  lsRequest = lsRequest & " xmlns:xsd='http://www.w3.org/1999/XMLSchema'" & vbCrLf
  lsRequest = lsRequest & " xmlns:xsi='http://www.w3.org/1999/XMLSchema-instance'>" & vbCrLf
  lsRequest = lsRequest & "<S:Body>" & vbCrLf
  lsRequest = lsRequest & "  <m:" & Method & " xmlns:m='" & Namespace & "'>"
  If Not VarType(Arguments) = vbInteger Then
    For i = 0 To UBound(Arguments, 1) - 1
      lsRequest = lsRequest & "    <" & Arguments(i, 0) & ">" & Arguments(i, 1) & "</" & Arguments(i, 0) & ">" & vbCrLf
    Next 'i
  End If
  lsRequest = lsRequest & "  </m:" & Method & ">" & vbCrLf
  lsRequest = lsRequest & "</S:Body>" & vbCrLf
  lsRequest = lsRequest & "</S:Envelope>"
  
  If ShowPackets Then MsgBox lsRequest, , "SOAP Request"
  
  ' Create XML HTTP object
  Set loXMLHTTP = CreateObject("Microsoft.XMLHTTP")
    
  ' Make request to SOAP service/method
  loXMLHTTP.Open "POST", Listener, False, "", ""
  ' (set header info)
  If Len(SOAPAction) > 0 Then
    loXMLHTTP.setRequestHeader "SOAPAction", SOAPAction
  Else
    loXMLHTTP.setRequestHeader "SOAPAction", Namespace & "#" & Method
  End If
  loXMLHTTP.setRequestHeader "Content-Type", "text/xml"
  loXMLHTTP.Send lsRequest

  ' If OK, get response
  If Len(loXMLHTTP.responseXML.XML) > 0 Then
    lsResponse = loXMLHTTP.responseXML.XML

    If ShowPackets Then MsgBox lsResponse, , "SOAP Response"

    ' Find type of call and if "Function" send back return value
    If Len(lsResponse) > 0 Then
      SOAPCall = GetReturnValue(lsResponse, Method)
    Else
      SOAPCall = ""
    End If
  Else
    MsgBox loXMLHTTP.responseText
  End If
    
End Function
Private Function GetReturnValue(ResponseData As String, Method As String) As String

' Get return value from response.
' IN:  ResponseData, response string
'      Method, method called
' OUT: GetReturnValue, return value
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010316 CFO Created
'******************************************************************************
  Dim loXMLDoc As DOMDocument
  Dim loRootElement As IXMLDOMElement
  Dim loNodelist As IXMLDOMNodeList
  Dim lnodX As IXMLDOMNode
  Dim lnodY As IXMLDOMNode
  Dim loErrXML As IXMLDOMParseError
  Dim llErr As Long
  Dim lsErr As String

  ' Create XML document
  Set loXMLDoc = CreateObject("Microsoft.XMLDOM")
       
  ' Load response data
  loXMLDoc.loadXML ResponseData
  
  ' Check if any XML parser error
  Set loErrXML = loXMLDoc.parseError
  If loErrXML.errorCode <> 0 Then
    Err.Raise loErrXML.errorCode, "XML", loErrXML.reason
  End If
  
  ' Check response
  Set loRootElement = loXMLDoc.documentElement
  For Each lnodX In loRootElement.childNodes(0).childNodes    '<SOAP:Body>
  
    ' Check if SOAP fault response
    If InStr(lnodX.nodeName, "Fault") > 0 Then
      For Each lnodY In lnodX.childNodes
        If InStr(lnodY.nodeName, "faultcode") > 0 Then
          If IsNumeric(lnodY.Text) Then
            llErr = CLng(lnodY.Text)
          Else
            llErr = -1
          End If
        ElseIf InStr(lnodY.nodeName, "faultstring") > 0 Then
          lsErr = lnodY.Text
        End If
        
        If llErr <> 0 And lsErr <> "" Then
          Exit For
        End If
      Next
      'Err.Raise llErr, "SOAPCall", lsErr
      GetReturnValue = "SOAP Error: " & lsErr
      
    ' If <Method>Reponse node found, get "return" value and send it back
    Else
      GetReturnValue = lnodX.childNodes(0).Text
      Exit Function
    End If
  Next
    
End Function
