Attribute VB_Name = "basXMLRS"
'******************************************************************************
' Module for XML Recordset Emulation declarations and functions
'******************************************************************************
' FileName:  basXMLRS.bas
' Creator:   Christian Forsberg
' Created:   2001-03-16
'******************************************************************************
' Version   Date   Who Comment
' 00.00.000 010316 CFO Created
'******************************************************************************
Option Explicit

' Program location
Private poXML As DOMDocument
Private psXML As String
Private poDataNodes As Object
Private piRecordPos As Integer
Public Sub XMLRSOpen(XML As String)
  
' Initialization of XML Recordset Emulation.
' IN:  XML, recordset in XML format
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010316 CFO Created
'******************************************************************************
  
  ' If already open, close first
  If Len(psXML) > 0 Then XMLRSClose
  
  ' Create DOM object
  Set poXML = CreateObject("Microsoft.XMLDOM")
  
  ' Load string
  psXML = XML
  
  ' Load DOM
  poXML.loadXML psXML

  ' Position data nodes
  Set poDataNodes = poXML.documentElement.selectNodes("//rs:data")
  Set poDataNodes = poDataNodes.Item(0).childNodes
  
End Sub
Public Function XMLRS(FieldID As Variant) As String
  
' Get field data (from current row).
' IN:  FieldID, field number or name to get data for
' OUT: XMLRS, field data
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010316 CFO Created
'******************************************************************************
  
  ' Check if field number or field name
  If IsNumeric(FieldID) Then
    ' Get Field Data
    XMLRS = poDataNodes(piRecordPos).Attributes(FieldID).Text
  Else
    ' Get Field Data
    XMLRS = poDataNodes(piRecordPos).Attributes.getNamedItem(FieldID).Text
  End If

End Function
Public Sub XMLRSMoveFirst()
  
' Move (pointer) to first row.
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010316 CFO Created
'******************************************************************************
  
  ' Set pointer to first record
  piRecordPos = 0

End Sub
Public Sub XMLRSMoveNext()

' Move (pointer) to next row.
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010316 CFO Created
'******************************************************************************
  
  ' Check not EOF
  If Not XMLRSEOF() Then
    ' Increase pointer
    piRecordPos = piRecordPos + 1
  End If
  
End Sub
Public Function XMLRSEOF() As Boolean

' Move (pointer) to first row.
' OUT: XMLRSEOF, indicates if we have reached EOF (End Of File)
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010316 CFO Created
'******************************************************************************
  
  ' Check EOF
  If piRecordPos > poDataNodes.length - 1 Then XMLRSEOF = True
   
End Function
Public Sub XMLRSClose()

' Close XML Recordset Emulation.
' Known bugs:
' Version   Date   Who Comment
' 00.00.000 010316 CFO Created
'******************************************************************************
  
  ' Reset private variables
  psXML = ""
  Set poXML = Nothing
  Set poDataNodes = Nothing
  piRecordPos = 0
  
End Sub
